#!/bin/bash

pause () {
    echo ''
    read -n 1 -s -r -p "Press any key to continue . . ."
    echo -e '\n\n'
}

echo -e '\n'

path=$(mdfind kMDItemCFBundleIdentifier = "com.ea.mac.thesims4" | grep ".app")
if [ $? -eq 0 ]; then
    IFS=$'\n' read -rd '' -a pathsArray <<<"$path"
    if [ ${#pathsArray[@]} -eq 1 ]; then
        echo "One game installation found: $path"
        folder="$(dirname "$path")/The Sims 4 Packs"
        if [ ! -d "$folder" ]; then
            echo "Creating Packs folder: $folder"
            mkdir "$folder"
        fi
        if [ ! -d "$folder" ]; then
            sudo mkdir "$folder"
			sudo chown -R "$USER" "$folder"
        fi
        echo "Opening Packs folder: $folder"
        open "$folder"
    else
        echo -e "Multiple game installations found, the script cannot continue:\n$path\n"
    fi
else
    echo "No The Sims 4 installation found, try the manual way."
fi

pause
